// LEDstick.cpp
// source code for LEDstick library
// 1 November 2016 - Dale Wheat - https://www.dalewheat.com

#include "Arduino.h"
#include "LEDstick.h"

// bitmap definitions

// 12LEDstick

const unsigned char _pins12[] {
  0b0000, // 0
  0b0001, // 1
  0b0010, // 2
  0b0010, // 3
  0b0100, // 4
  0b0100, // 5
  0b0001, // 6
  0b0001, // 7
  0b1000, // 8
  0b0010, // 9
  0b1000, // 10
  0b0100, // 11
  0b1000, // 12
};

const unsigned char _mask12[] = {
  0b0000, // 0
  0b0011, // 1
  0b0011, // 2
  0b0110, // 3
  0b0110, // 4
  0b0101, // 5
  0b0101, // 6
  0b1001, // 7
  0b1001, // 8
  0b1010, // 9
  0b1010, // 10
  0b1100, // 11
  0b1100, // 12
};

// class constructor

// 12LEDstick

LEDstick::LEDstick(byte node1, byte node2, byte node3, byte node4)
{
	// TODO - validate pin values
	
	// set data direction to "input" for all nodes
	
	pinMode(node1, INPUT);
	pinMode(node2, INPUT);
	pinMode(node3, INPUT);
	pinMode(node4, INPUT);
	
	// turn off all LEDs by writing 0's to all pins
	
	digitalWrite(node1, LOW);
	digitalWrite(node2, LOW);
	digitalWrite(node3, LOW);
	digitalWrite(node4, LOW);
	
	// remember node pins
	
	_node[0] = node1;
	_node[1] = node2;
	_node[2] = node3;
	_node[3] = node4;
}

// class methods

void LEDstick::led(byte n)
{
  // TODO - validate LED (n) value, depending on size
  
  // turn off all LEDs to prevent ghosting

  digitalWrite(_node[0], LOW);
  digitalWrite(_node[1], LOW);
  digitalWrite(_node[2], LOW);
  digitalWrite(_node[3], LOW);

  // configure node pins for proper direction

  if(_mask12[n] & 0b0001) pinMode(_node[0], OUTPUT); else pinMode(_node[0], INPUT);
  if(_mask12[n] & 0b0010) pinMode(_node[1], OUTPUT); else pinMode(_node[1], INPUT);
  if(_mask12[n] & 0b0100) pinMode(_node[2], OUTPUT); else pinMode(_node[2], INPUT);
  if(_mask12[n] & 0b1000) pinMode(_node[3], OUTPUT); else pinMode(_node[3], INPUT);

  // turn on the right pin to light the LED

  if(_pins12[n] & 0b0001) digitalWrite(_node[0], HIGH); else digitalWrite(_node[0], LOW);
  if(_pins12[n] & 0b0010) digitalWrite(_node[1], HIGH); else digitalWrite(_node[1], LOW);
  if(_pins12[n] & 0b0100) digitalWrite(_node[2], HIGH); else digitalWrite(_node[2], LOW);
  if(_pins12[n] & 0b1000) digitalWrite(_node[3], HIGH); else digitalWrite(_node[3], LOW);
}
